function out = fct_process_data_p1p2hazard(data, T)

% % % DESCRIPTION
% % % Use data on incomplete spells to compute p1,p2 and the hazard rate.
% % % INPUT
% % % data -- data on incomplete spells spells only
% % % T -- the largest non-truncated duration
% % % OUTPUT
% % % p1,p2 -- probabilities of completing a spell
% % % HR -- hazard rate

% COUNTING 
    sel = data(:,1)>T;
    NINC = sum(data(sel,3));
    Npeople = sum(data(:,3));

% ADD MISSING OBSERVATIONS
    sel = (data(:,1)<=T) & (data(:,2)<=T );
    data_complete = data(sel,1:3);
    Tsym_min = min(min(data(:,1:2)));
    Tsym_max = max(max(data(:,1:2)));   
    data_extend = fct_add_missing_obs(data(:,1:3),Tsym_min,Tsym_max,Tsym_min,Tsym_max);
    
% SYMMETRIZE DATA
    N    = Tsym_max-Tsym_min+1;
    TEMP = reshape(data_extend(:,3),N,N);
    TEMP = (TEMP+TEMP')/2;
    data_extend(:,3) = TEMP(:); 

% HAZARD RATE
    for t = 0:T
        sel1 = data(:,1)==t;
        sel2 = data(:,1)>=t;
        HR(t+1,1) = t;
        HR(t+1,2) = sum(data(sel1,3))/sum(data(sel2,3));
        
        sel1 = data_extend(:,1)==t;
        sel2 = data_extend(:,1)>=t;    
        HR(t+1,3) = sum(data_extend(sel1,3))/(sum(data_extend(sel2,3))+NINC);
    end
    
% VALUE OF p2, BOUNDS ON p1
    sel1 = (data(:,1)<=T);  % 
    sel2 = (data(:,1)<=T) & (data(:,2)<=T); % 2 complete spells
    p2 = sum(data(sel2,3))/sum(data(sel1,3));
    
    sel3 = (data(:,2) == 300);
    sel4 = (data(:,2) == 400);
    sel5 = (data(:,2) == 500);
    
    p1_den1 = sum(data(sel1,3)) + sum(data(sel3,3));
    p1_den2 = p1_den1 + sum(data(sel4,3)) + sum(data(sel5,3)); 
    p1_up = sum(data(sel1,3))/p1_den1;
    p1_low = sum(data(sel1,3))/p1_den2;
    
    if sum(sel3)==0
        p1_up = p2;
        p1_low = 1-NINC/Npeople;
    end

% OUTPUT    
    out.HR = HR;
    out.p2 = p2;
    %out.p1 = 1-NINC/Npeople;
    out.p1_low = p1_low;
    out.p1_up = p1_up;
    
return
